/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.stream;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.stream.EventStreamType;
import com.swirlds.common.stream.HashCalculatorForStream;
import com.swirlds.common.stream.MultiStream;
import com.swirlds.common.stream.QueueThreadObjectStream;
import com.swirlds.common.stream.QueueThreadObjectStreamConfiguration;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.common.stream.RunningHashCalculatorForStream;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.stream.internal.TimestampStreamFileWriter;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.base.crypto.Signer;
import org.hiero.consensus.config.EventConfig;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.node.NodeId;

public class DefaultConsensusEventStream
implements ConsensusEventStream {
    private static final Logger logger = LogManager.getLogger(DefaultConsensusEventStream.class);
    private final MultiStream<CesEvent> multiStream;
    private final Predicate<CesEvent> isLastEventInFreezeCheck;
    private QueueThreadObjectStream<CesEvent> hashQueueThread;
    private QueueThreadObjectStream<CesEvent> writeQueueThread;
    private TimestampStreamFileWriter<CesEvent> streamFileWriter;
    private Hash initialHash = new Hash(new byte[DigestType.SHA_384.digestLength()]);
    private volatile boolean freezePeriodStarted = false;
    private final RateLimitedLogger eventAfterFreezeLogger;

    public DefaultConsensusEventStream(@NonNull PlatformContext platformContext, @NonNull NodeId selfId, @NonNull Signer signer, @NonNull String nodeName, @NonNull Predicate<CesEvent> isLastEventInFreezeCheck) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(signer);
        Objects.requireNonNull(nodeName);
        Objects.requireNonNull(isLastEventInFreezeCheck);
        this.eventAfterFreezeLogger = new RateLimitedLogger(logger, platformContext.getTime(), Duration.ofMinutes(1L));
        EventConfig eventConfig = (EventConfig)platformContext.getConfiguration().getConfigData(EventConfig.class);
        boolean enableEventStreaming = eventConfig.enableEventStreaming();
        String eventsLogDir = eventConfig.eventsLogDir();
        long eventsLogPeriod = eventConfig.eventsLogPeriod();
        int eventStreamQueueCapacity = eventConfig.eventStreamQueueCapacity();
        if (enableEventStreaming) {
            String eventStreamDir = eventsLogDir + "/events_" + nodeName;
            try {
                Files.createDirectories(Paths.get(eventStreamDir, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not create directory for event stream", e);
            }
            this.streamFileWriter = new TimestampStreamFileWriter(eventStreamDir, eventsLogPeriod * 1000L, signer, false, (StreamType)EventStreamType.getInstance());
            this.writeQueueThread = new QueueThreadObjectStreamConfiguration(AdHocThreadManager.getStaticThreadManager()).setNodeId(selfId).setComponent("event-stream").setThreadName("write-queue").setCapacity(eventStreamQueueCapacity).setForwardTo(this.streamFileWriter).build();
            this.writeQueueThread.start();
        }
        platformContext.getMetrics().getOrCreate((MetricConfig)new FunctionGauge.Config("platform:info", "eventStreamQueueSize", Integer.class, this::getEventStreamingQueueSize).withDescription("size of the queue from which we take events and write to EventStream file").withUnit("count"));
        platformContext.getMetrics().getOrCreate((MetricConfig)new FunctionGauge.Config("platform:info", "hashQueueSize", Integer.class, this::getHashQueueSize).withDescription("size of the queue from which we take events, calculate Hash and RunningHash").withUnit("count"));
        RunningHashCalculatorForStream runningHashCalculator = new RunningHashCalculatorForStream();
        HashCalculatorForStream hashCalculator = new HashCalculatorForStream((LinkedObjectStream)runningHashCalculator);
        this.hashQueueThread = new QueueThreadObjectStreamConfiguration(AdHocThreadManager.getStaticThreadManager()).setNodeId(selfId).setComponent("event-stream").setThreadName("hash-queue").setCapacity(eventStreamQueueCapacity).setForwardTo((LinkedObjectStream)hashCalculator).build();
        this.hashQueueThread.start();
        this.multiStream = new MultiStream(enableEventStreaming ? List.of(this.hashQueueThread, this.writeQueueThread) : List.of(this.hashQueueThread));
        this.multiStream.setRunningHash(this.initialHash);
        this.isLastEventInFreezeCheck = isLastEventInFreezeCheck;
    }

    public DefaultConsensusEventStream(@NonNull Time time, @NonNull MultiStream<CesEvent> multiStream, @NonNull Predicate<CesEvent> isLastEventInFreezeCheck) {
        this.eventAfterFreezeLogger = new RateLimitedLogger(logger, Objects.requireNonNull(time), Duration.ofMinutes(1L));
        this.multiStream = Objects.requireNonNull(multiStream);
        multiStream.setRunningHash(this.initialHash);
        this.isLastEventInFreezeCheck = Objects.requireNonNull(isLastEventInFreezeCheck);
    }

    public void stop() {
        this.writeQueueThread.stop();
        this.hashQueueThread.stop();
        this.streamFileWriter.close();
        this.multiStream.close();
    }

    @Override
    public void addEvents(@NonNull List<CesEvent> events) {
        events.forEach(event -> {
            if (!this.freezePeriodStarted) {
                this.multiStream.addObject((RunningHashable)event);
                if (this.isLastEventInFreezeCheck.test((CesEvent)event)) {
                    this.freezePeriodStarted = true;
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = () -> ((CesEvent)event).getTimestamp();
                    logger.info(LogMarker.EVENT_STREAM.getMarker(), "ConsensusTimestamp of the last Event to be written into file before restarting: {}", supplierArray);
                    this.multiStream.close();
                }
            } else {
                this.eventAfterFreezeLogger.warn(LogMarker.EVENT_STREAM.getMarker(), "Event {} dropped after freezePeriodStarted!", new Object[]{event.getPlatformEvent().getDescriptor()});
            }
        });
    }

    @Override
    public void legacyHashOverride(@NonNull RunningEventHashOverride runningEventHashOverride) {
        try {
            if (this.hashQueueThread != null) {
                this.hashQueueThread.pause();
            }
            if (this.writeQueueThread != null) {
                this.writeQueueThread.pause();
            }
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to pause queue threads", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.streamFileWriter != null) {
            this.streamFileWriter.setStartWriteAtCompleteWindow(runningEventHashOverride.isReconnect());
        }
        this.initialHash = new Hash(runningEventHashOverride.legacyRunningEventHash());
        logger.info(LogMarker.EVENT_STREAM.getMarker(), "EventStreamManager::updateRunningHash: {}", (Object)this.initialHash);
        this.multiStream.setRunningHash(this.initialHash);
        if (this.hashQueueThread != null) {
            this.hashQueueThread.resume();
        }
        if (this.writeQueueThread != null) {
            this.writeQueueThread.resume();
        }
    }

    private int getHashQueueSize() {
        return this.hashQueueThread == null ? 0 : this.hashQueueThread.getQueue().size();
    }

    private int getEventStreamingQueueSize() {
        return this.writeQueueThread == null ? 0 : this.writeQueueThread.getQueue().size();
    }
}

