/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.clock;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.platform.health.OSHealthCheckConfig;
import com.swirlds.platform.health.OSHealthCheckUtils;
import com.swirlds.platform.health.clock.OSClockSourceSpeedCheck;

public final class OSClockSpeedSourceChecker {
    private OSClockSpeedSourceChecker() {
    }

    public static boolean performClockSourceSpeedCheck(StringBuilder sb, OSHealthCheckConfig osHealthConfig) {
        OSClockSourceSpeedCheck.Report clockSourceSpeed = OSClockSourceSpeedCheck.execute();
        return OSClockSpeedSourceChecker.appendReport(sb, clockSourceSpeed, osHealthConfig.minClockCallsPerSec());
    }

    private static boolean appendReport(StringBuilder sb, OSClockSourceSpeedCheck.Report clockReport, long minClockCallsPerSec) {
        if (clockReport.callsPerSec() < minClockCallsPerSec) {
            OSHealthCheckUtils.reportHeader(sb, OSClockSourceSpeedCheck.Report.name(), false);
            StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS clock source is too slow. Calls/sec Minimum: %d, Achieved: %d", minClockCallsPerSec, clockReport.callsPerSec()));
            return false;
        }
        OSHealthCheckUtils.reportHeader(sb, OSClockSourceSpeedCheck.Report.name(), true);
        StringFormattingUtils.addLine((StringBuilder)sb, (String)clockReport.toString());
        return true;
    }
}

