/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.hapi.utils.HederaExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public abstract class AbstractNftViewCall
extends AbstractRevertibleTokenViewCall {
    protected final long serialNo;

    protected AbstractNftViewCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, long serialNo) {
        super(gasCalculator, enhancement, token);
        this.serialNo = serialNo;
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        if (this.token != null && this.token.tokenType() == TokenType.FUNGIBLE_COMMON) {
            return Call.PricedResult.gasOnly(FullResult.haltResult(HederaExceptionalHaltReason.ERROR_DECODING_PRECOMPILE_INPUT, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_TOKEN_ID, false);
        }
        return super.execute();
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        Objects.requireNonNull(token);
        Nft nft = this.nativeOperations().getNft(token.tokenIdOrThrow(), this.serialNo);
        if (nft == null) {
            ResponseCodeEnum status = this.missingNftStatus();
            return Call.PricedResult.gasOnly(FullResult.ordinalRevertResult(status, this.gasCalculator.viewGasRequirement()), status, true);
        }
        return this.resultOfViewingNft(token, nft);
    }

    protected abstract ResponseCodeEnum missingNftStatus();

    @NonNull
    protected abstract Call.PricedResult resultOfViewingNft(@NonNull Token var1, @NonNull Nft var2);
}

