/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenReferenceJsonCodec;
import com.hedera.hapi.node.token.codec.TokenReferenceProtoCodec;
import com.hedera.hapi.node.token.schema.TokenReferenceSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TokenReference {
    public static final Codec<TokenReference> PROTOBUF = new TokenReferenceProtoCodec();
    public static final JsonCodec<TokenReference> JSON = new TokenReferenceJsonCodec();
    public static final TokenReference DEFAULT = TokenReference.newBuilder().build();
    private final OneOf<TokenIdentifierOneOfType> tokenIdentifier;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TokenReference(OneOf<TokenIdentifierOneOfType> tokenIdentifier) {
        this.$unknownFields = null;
        if (tokenIdentifier == null) {
            throw new NullPointerException("Parameter 'tokenIdentifier' must be supplied and can not be null");
        }
        this.tokenIdentifier = tokenIdentifier;
    }

    public TokenReference(OneOf<TokenIdentifierOneOfType> tokenIdentifier, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (tokenIdentifier == null) {
            throw new NullPointerException("Parameter 'tokenIdentifier' must be supplied and can not be null");
        }
        this.tokenIdentifier = tokenIdentifier;
    }

    public OneOf<TokenIdentifierOneOfType> tokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.tokenIdentifier.kind() == TokenIdentifierOneOfType.FUNGIBLE_TOKEN) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenReferenceSchema.FUNGIBLE_TOKEN, (Object)((TokenID)this.tokenIdentifier.as()), TokenID.PROTOBUF);
            }
            if (this.tokenIdentifier.kind() == TokenIdentifierOneOfType.NFT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenReferenceSchema.NFT, (Object)((NftID)this.tokenIdentifier.as()), NftID.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.tokenIdentifier != null && !this.tokenIdentifier.equals(TokenReference.DEFAULT.tokenIdentifier)) {
                result = 31 * result + this.tokenIdentifier.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenReference thatObj = (TokenReference)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.tokenIdentifier == null && thatObj.tokenIdentifier != null) {
            return false;
        }
        if (this.tokenIdentifier != null && !this.tokenIdentifier.equals(thatObj.tokenIdentifier)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TokenReference[tokenIdentifier=" + String.valueOf(this.tokenIdentifier) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public TokenID fungibleToken() {
        return this.tokenIdentifier.kind() == TokenIdentifierOneOfType.FUNGIBLE_TOKEN ? (TokenID)this.tokenIdentifier.value() : null;
    }

    public boolean hasFungibleToken() {
        return this.tokenIdentifier.kind() == TokenIdentifierOneOfType.FUNGIBLE_TOKEN;
    }

    public TokenID fungibleTokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasFungibleToken() ? this.fungibleToken() : defaultValue;
    }

    @NonNull
    public TokenID fungibleTokenOrThrow() {
        return Objects.requireNonNull(this.fungibleToken(), "Field fungibleToken is null");
    }

    @Nullable
    public NftID nft() {
        return this.tokenIdentifier.kind() == TokenIdentifierOneOfType.NFT ? (NftID)this.tokenIdentifier.value() : null;
    }

    public boolean hasNft() {
        return this.tokenIdentifier.kind() == TokenIdentifierOneOfType.NFT;
    }

    public NftID nftOrElse(@NonNull NftID defaultValue) {
        return this.hasNft() ? this.nft() : defaultValue;
    }

    @NonNull
    public NftID nftOrThrow() {
        return Objects.requireNonNull(this.nft(), "Field nft is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenIdentifier, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum TokenIdentifierOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        FUNGIBLE_TOKEN(1, "fungible_token"),
        NFT(2, "nft");

        private final int protoOrdinal;
        private final String protoName;

        private TokenIdentifierOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static TokenIdentifierOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> FUNGIBLE_TOKEN;
                case 2 -> NFT;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static TokenIdentifierOneOfType fromString(String name) {
            return switch (name) {
                case "fungible_token", "FUNGIBLE_TOKEN" -> FUNGIBLE_TOKEN;
                case "nft", "NFT" -> NFT;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<TokenIdentifierOneOfType> tokenIdentifier = TokenReferenceProtoCodec.TOKEN_IDENTIFIER_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<TokenIdentifierOneOfType> tokenIdentifier) {
            this.$unknownFields = null;
            this.tokenIdentifier = tokenIdentifier;
        }

        public Builder(OneOf<TokenIdentifierOneOfType> tokenIdentifier, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.tokenIdentifier = tokenIdentifier;
        }

        public TokenReference build() {
            return new TokenReference(this.tokenIdentifier);
        }

        public Builder fungibleToken(@Nullable TokenID fungibleToken) {
            this.tokenIdentifier = new OneOf((Enum)TokenIdentifierOneOfType.FUNGIBLE_TOKEN, (Object)fungibleToken);
            return this;
        }

        public Builder fungibleToken(TokenID.Builder builder) {
            this.tokenIdentifier = new OneOf((Enum)TokenIdentifierOneOfType.FUNGIBLE_TOKEN, (Object)builder.build());
            return this;
        }

        public Builder nft(@Nullable NftID nft) {
            this.tokenIdentifier = new OneOf((Enum)TokenIdentifierOneOfType.NFT, (Object)nft);
            return this;
        }

        public Builder nft(NftID.Builder builder) {
            this.tokenIdentifier = new OneOf((Enum)TokenIdentifierOneOfType.NFT, (Object)builder.build());
            return this;
        }
    }
}

