/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.event.codec;

import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.event.schema.GossipEventSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GossipEventJsonCodec
implements JsonCodec<GossipEvent> {
    @NonNull
    public GossipEvent parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            EventCore temp_event_core = null;
            Bytes temp_signature = Bytes.EMPTY;
            List<Bytes> temp_transactions = Collections.emptyList();
            List temp_parents = Collections.emptyList();
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "eventCore": {
                        temp_event_core = (EventCore)EventCore.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block14;
                    }
                    case "signature": {
                        temp_signature = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "transactions": {
                        temp_transactions = kvPair.value().arr().value().stream().map(v -> Bytes.fromBase64((String)v.STRING().getText())).toList();
                        continue block14;
                    }
                    case "parents": {
                        temp_parents = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), EventDescriptor.JSON, (int)(maxDepth - 1));
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new GossipEvent(temp_event_core, temp_signature, temp_transactions, temp_parents);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull GossipEvent data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.eventCore() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"eventCore", EventCore.JSON, (Object)data.eventCore()));
        }
        if (data.signature() != Bytes.EMPTY && data.signature() != null && data.signature().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"signature", (Bytes)data.signature()));
        }
        if (!data.transactions().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"transactions", (FieldDefinition)GossipEventSchema.TRANSACTIONS, data.transactions()));
        }
        if (!data.parents().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"parents", EventDescriptor.JSON, data.parents()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

