/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls.spi;

import io.helidon.common.tls.TlsManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

class TlsManagerCache {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<Object, TlsManager> CACHE = new HashMap<Object, TlsManager>();

    private TlsManagerCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> TlsManager getOrCreate(T configBean, Function<T, TlsManager> creator) {
        Objects.requireNonNull(configBean);
        Objects.requireNonNull(creator);
        LOCK.lock();
        try {
            TlsManager manager = CACHE.get(configBean);
            if (manager != null) {
                TlsManager tlsManager = manager;
                return tlsManager;
            }
            manager = creator.apply(configBean);
            TlsManager existing = CACHE.put(configBean, manager);
            assert (existing == null);
            TlsManager tlsManager = manager;
            return tlsManager;
        }
        finally {
            LOCK.unlock();
        }
    }
}

