/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.CodeCache;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AddModOperation;
import org.hyperledger.besu.evm.operation.AddOperation;
import org.hyperledger.besu.evm.operation.AndOperation;
import org.hyperledger.besu.evm.operation.ByteOperation;
import org.hyperledger.besu.evm.operation.ChainIdOperation;
import org.hyperledger.besu.evm.operation.DivOperation;
import org.hyperledger.besu.evm.operation.DupOperation;
import org.hyperledger.besu.evm.operation.ExpOperation;
import org.hyperledger.besu.evm.operation.GtOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.IsZeroOperation;
import org.hyperledger.besu.evm.operation.JumpDestOperation;
import org.hyperledger.besu.evm.operation.JumpOperation;
import org.hyperledger.besu.evm.operation.JumpiOperation;
import org.hyperledger.besu.evm.operation.LtOperation;
import org.hyperledger.besu.evm.operation.ModOperation;
import org.hyperledger.besu.evm.operation.MulModOperation;
import org.hyperledger.besu.evm.operation.MulOperation;
import org.hyperledger.besu.evm.operation.NotOperation;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.OrOperation;
import org.hyperledger.besu.evm.operation.PopOperation;
import org.hyperledger.besu.evm.operation.Push0Operation;
import org.hyperledger.besu.evm.operation.PushOperation;
import org.hyperledger.besu.evm.operation.SDivOperation;
import org.hyperledger.besu.evm.operation.SGtOperation;
import org.hyperledger.besu.evm.operation.SLtOperation;
import org.hyperledger.besu.evm.operation.SModOperation;
import org.hyperledger.besu.evm.operation.SignExtendOperation;
import org.hyperledger.besu.evm.operation.StopOperation;
import org.hyperledger.besu.evm.operation.SubOperation;
import org.hyperledger.besu.evm.operation.SwapOperation;
import org.hyperledger.besu.evm.operation.VirtualOperation;
import org.hyperledger.besu.evm.operation.XorOperation;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EVM {
    private static final Logger LOG = LoggerFactory.getLogger(EVM.class);
    protected static final Operation.OperationResult OVERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
    protected static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final OperationRegistry operations;
    private final GasCalculator gasCalculator;
    private final Operation endOfScriptStop;
    private final CodeCache codeCache;
    private final EvmConfiguration evmConfiguration;
    private final EvmSpecVersion evmSpecVersion;
    private final boolean enableShanghai;

    public EVM(OperationRegistry operations, GasCalculator gasCalculator, EvmConfiguration evmConfiguration, EvmSpecVersion evmSpecVersion) {
        this.operations = operations;
        this.gasCalculator = gasCalculator;
        this.endOfScriptStop = new VirtualOperation(new StopOperation(gasCalculator));
        this.evmConfiguration = evmConfiguration;
        this.codeCache = new CodeCache(evmConfiguration);
        this.evmSpecVersion = evmSpecVersion;
        this.enableShanghai = EvmSpecVersion.SHANGHAI.ordinal() <= evmSpecVersion.ordinal();
    }

    public GasCalculator getGasCalculator() {
        return this.gasCalculator;
    }

    public int getMaxEOFVersion() {
        return this.evmSpecVersion.maxEofVersion;
    }

    public EvmConfiguration getEvmConfiguration() {
        return this.evmConfiguration;
    }

    public EvmSpecVersion getEvmVersion() {
        return this.evmSpecVersion;
    }

    public Optional<Bytes> getChainId() {
        Operation op = this.operations.get(70);
        if (op instanceof ChainIdOperation) {
            ChainIdOperation chainIdOperation = (ChainIdOperation)op;
            return Optional.of(chainIdOperation.getChainId());
        }
        return Optional.empty();
    }

    public void runToHalt(MessageFrame frame, OperationTracer tracing) {
        this.evmSpecVersion.maybeWarnVersion();
        OperationTracer operationTracer = tracing == OperationTracer.NO_TRACING ? null : tracing;
        byte[] code = frame.getCode().getBytes().toArrayUnsafe();
        Operation[] operationArray = this.operations.getOperations();
        while (frame.getState() == MessageFrame.State.CODE_EXECUTING) {
            Operation.OperationResult result;
            Operation currentOperation;
            int opcode;
            int pc = frame.getPC();
            try {
                opcode = code[pc] & 0xFF;
                currentOperation = operationArray[opcode];
            }
            catch (ArrayIndexOutOfBoundsException aiiobe) {
                opcode = 0;
                currentOperation = this.endOfScriptStop;
            }
            frame.setCurrentOperation(currentOperation);
            if (operationTracer != null) {
                operationTracer.tracePreExecution(frame);
            }
            try {
                result = switch (opcode) {
                    case 0 -> StopOperation.staticOperation(frame);
                    case 1 -> AddOperation.staticOperation(frame);
                    case 2 -> MulOperation.staticOperation(frame);
                    case 3 -> SubOperation.staticOperation(frame);
                    case 4 -> DivOperation.staticOperation(frame);
                    case 5 -> SDivOperation.staticOperation(frame);
                    case 6 -> ModOperation.staticOperation(frame);
                    case 7 -> SModOperation.staticOperation(frame);
                    case 8 -> AddModOperation.staticOperation(frame);
                    case 9 -> MulModOperation.staticOperation(frame);
                    case 10 -> ExpOperation.staticOperation(frame, this.gasCalculator);
                    case 11 -> SignExtendOperation.staticOperation(frame);
                    case 12, 13, 14, 15 -> InvalidOperation.INVALID_RESULT;
                    case 16 -> LtOperation.staticOperation(frame);
                    case 17 -> GtOperation.staticOperation(frame);
                    case 18 -> SLtOperation.staticOperation(frame);
                    case 19 -> SGtOperation.staticOperation(frame);
                    case 21 -> IsZeroOperation.staticOperation(frame);
                    case 22 -> AndOperation.staticOperation(frame);
                    case 23 -> OrOperation.staticOperation(frame);
                    case 24 -> XorOperation.staticOperation(frame);
                    case 25 -> NotOperation.staticOperation(frame);
                    case 26 -> ByteOperation.staticOperation(frame);
                    case 80 -> PopOperation.staticOperation(frame);
                    case 86 -> JumpOperation.staticOperation(frame);
                    case 87 -> JumpiOperation.staticOperation(frame);
                    case 91 -> JumpDestOperation.JUMPDEST_SUCCESS;
                    case 95 -> {
                        if (this.enableShanghai) {
                            yield Push0Operation.staticOperation(frame);
                        }
                        yield InvalidOperation.INVALID_RESULT;
                    }
                    case 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127 -> PushOperation.staticOperation(frame, code, pc, opcode - 95);
                    case 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143 -> DupOperation.staticOperation(frame, opcode - 127);
                    case 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159 -> SwapOperation.staticOperation(frame, opcode - 143);
                    default -> {
                        frame.setCurrentOperation(currentOperation);
                        yield currentOperation.execute(frame, this);
                    }
                };
            }
            catch (OverflowException oe) {
                result = OVERFLOW_RESPONSE;
            }
            catch (UnderflowException ue) {
                result = UNDERFLOW_RESPONSE;
            }
            ExceptionalHaltReason haltReason = result.getHaltReason();
            if (haltReason != null) {
                LOG.trace("MessageFrame evaluation halted because of {}", (Object)haltReason);
                frame.setExceptionalHaltReason(Optional.of(haltReason));
                frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
            } else if (frame.decrementRemainingGas(result.getGasCost()) < 0L) {
                frame.setExceptionalHaltReason(Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS));
                frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
            }
            if (frame.getState() == MessageFrame.State.CODE_EXECUTING) {
                int currentPC = frame.getPC();
                int opSize = result.getPcIncrement();
                frame.setPC(currentPC + opSize);
            }
            if (operationTracer == null) continue;
            operationTracer.tracePostExecution(frame, result);
        }
    }

    public Operation[] getOperationsUnsafe() {
        return this.operations.getOperations();
    }

    public Code getCode(Hash codeHash, Bytes codeBytes) {
        Code result;
        Code code = result = codeHash == null ? null : this.codeCache.getIfPresent(codeHash);
        if (result == null) {
            result = CodeFactory.createCode(codeBytes, this.evmSpecVersion.getMaxEofVersion(), false);
            if (codeHash != null) {
                this.codeCache.put(codeHash, result);
            }
        }
        return result;
    }
}

