/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.List;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.AccessListEntry;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface GasCalculator {
    public long idPrecompiledContractGasCost(Bytes var1);

    public long getEcrecPrecompiledContractGasCost();

    public long sha256PrecompiledContractGasCost(Bytes var1);

    public long ripemd160PrecompiledContractGasCost(Bytes var1);

    public long getZeroTierGasCost();

    public long getVeryLowTierGasCost();

    public long getLowTierGasCost();

    public long getBaseTierGasCost();

    public long getMidTierGasCost();

    public long getHighTierGasCost();

    public long callOperationBaseGasCost();

    @Deprecated(since="24.2.0", forRemoval=true)
    default public long callOperationGasCost(MessageFrame frame, long stipend, long inputDataOffset, long inputDataLength, long outputDataOffset, long outputDataLength, Wei transferValue, Account recipient, Address contract) {
        return this.callOperationGasCost(frame, stipend, inputDataOffset, inputDataLength, outputDataOffset, outputDataLength, transferValue, recipient, contract, true);
    }

    public long callOperationGasCost(MessageFrame var1, long var2, long var4, long var6, long var8, long var10, Wei var12, Account var13, Address var14, boolean var15);

    public long getAdditionalCallStipend();

    public long gasAvailableForChildCall(MessageFrame var1, long var2, boolean var4);

    public long createOperationGasCost(MessageFrame var1);

    public long create2OperationGasCost(MessageFrame var1);

    public long gasAvailableForChildCreate(long var1);

    public long dataCopyOperationGasCost(MessageFrame var1, long var2, long var4);

    public long memoryExpansionGasCost(MessageFrame var1, long var2, long var4);

    public long getBalanceOperationGasCost();

    public long getBlockHashOperationGasCost();

    public long expOperationGasCost(int var1);

    public long extCodeCopyOperationGasCost(MessageFrame var1, long var2, long var4);

    public long extCodeHashOperationGasCost();

    public long getExtCodeSizeOperationGasCost();

    public long getJumpDestOperationGasCost();

    public long logOperationGasCost(MessageFrame var1, long var2, long var4, int var6);

    public long mLoadOperationGasCost(MessageFrame var1, long var2);

    public long mStoreOperationGasCost(MessageFrame var1, long var2);

    public long mStore8OperationGasCost(MessageFrame var1, long var2);

    public long selfDestructOperationGasCost(Account var1, Wei var2);

    public long keccak256OperationGasCost(MessageFrame var1, long var2, long var4);

    public long getSloadOperationGasCost();

    public long calculateStorageCost(UInt256 var1, Supplier<UInt256> var2, Supplier<UInt256> var3);

    public long calculateStorageRefundAmount(UInt256 var1, Supplier<UInt256> var2, Supplier<UInt256> var3);

    public long getSelfDestructRefundAmount();

    default public long getColdSloadCost() {
        return 0L;
    }

    default public long getColdAccountAccessCost() {
        return 0L;
    }

    default public long getWarmStorageReadCost() {
        return 0L;
    }

    default public boolean isPrecompile(Address address) {
        return false;
    }

    default public long modExpGasCost(Bytes input) {
        return 0L;
    }

    public long codeDepositGasCost(int var1);

    public long transactionIntrinsicGasCost(Bytes var1, boolean var2);

    default public long accessListGasCost(List<AccessListEntry> accessListEntries) {
        return this.accessListGasCost(accessListEntries.size(), accessListEntries.stream().mapToInt(e -> e.storageKeys().size()).sum());
    }

    default public long accessListGasCost(int addresses, int storageSlots) {
        return 0L;
    }

    default public long getMaxRefundQuotient() {
        return 2L;
    }

    public long getMaximumTransactionCost(int var1);

    public long getMinimumTransactionCost();

    default public long getTransientLoadOperationGasCost() {
        return 0L;
    }

    default public long getTransientStoreOperationGasCost() {
        return 0L;
    }

    default public long blobGasCost(int blobCount) {
        return 0L;
    }

    default public long computeExcessBlobGas(long parentExcessBlobGas, int newBlobs) {
        return 0L;
    }

    default public long computeExcessBlobGas(long parentExcessBlobGas, long blobGasUsed) {
        return 0L;
    }
}

