/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractCreateOperation;

public class CreateOperation
extends AbstractCreateOperation {
    public CreateOperation(GasCalculator gasCalculator, int maxInitcodeSize) {
        super(240, "CREATE", 3, 1, gasCalculator, maxInitcodeSize);
    }

    @Override
    public long cost(MessageFrame frame) {
        return this.gasCalculator().createOperationGasCost(frame);
    }

    @Override
    protected Address targetContractAddress(MessageFrame frame) {
        Account sender = frame.getWorldUpdater().get(frame.getRecipientAddress());
        Address address = Address.contractAddress((Address)frame.getRecipientAddress(), (long)(sender.getNonce() - 1L));
        frame.warmUpAddress(address);
        return address;
    }
}

