/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage;

import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.UsageEstimate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransferList;

public enum SingletonEstimatorUtils implements EstimatorUtils
{
    ESTIMATOR_UTILS;


    @Override
    public long baseNetworkRbs() {
        return 6480L;
    }

    @Override
    public UsageEstimate baseEstimate(TransactionBody txn, SigUsage sigUsage) {
        FeeComponents.Builder base = FeeComponents.newBuilder().setBpr(4L).setVpt((long)sigUsage.numSigs()).setBpt(this.baseBodyBytes(txn) + (long)sigUsage.sigsSize());
        UsageEstimate estimate = new UsageEstimate(base);
        estimate.addRbs((long)this.baseRecordBytes(txn) * 180L);
        return estimate;
    }

    @Override
    public FeeData withDefaultTxnPartitioning(FeeComponents usage, SubType subType, long networkRbh, int numPayerKeys) {
        FeeData.Builder usages = FeeData.newBuilder();
        FeeComponents.Builder network = FeeComponents.newBuilder().setConstant(1L).setBpt(usage.getBpt()).setVpt(usage.getVpt()).setRbh(networkRbh);
        FeeComponents.Builder node = FeeComponents.newBuilder().setConstant(1L).setBpt(usage.getBpt()).setVpt((long)numPayerKeys).setBpr(usage.getBpr()).setSbpr(usage.getSbpr());
        FeeComponents.Builder service = FeeComponents.newBuilder().setConstant(1L).setRbh(usage.getRbh()).setSbh(usage.getSbh()).setTv(usage.getTv());
        return usages.setNetworkdata(network).setNodedata(node).setServicedata(service).setSubType(subType).build();
    }

    @Override
    public FeeData withDefaultQueryPartitioning(FeeComponents usage) {
        FeeData.Builder usages = FeeData.newBuilder();
        FeeComponents.Builder node = FeeComponents.newBuilder().setConstant(1L).setBpt(usage.getBpt()).setBpr(usage.getBpr()).setSbpr(usage.getSbpr());
        return usages.setNodedata(node).build();
    }

    int baseRecordBytes(TransactionBody txn) {
        return 132 + txn.getMemoBytes().size() + this.transferListBytes(txn.getCryptoTransfer().getTransfers());
    }

    private int transferListBytes(TransferList transfers) {
        return 32 * transfers.getAccountAmountsCount();
    }
}

