/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.Weighted;
import io.helidon.common.Weights;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class HelidonServiceLoader<T>
implements Iterable<T> {
    public static final String SYSTEM_PROPERTY_EXCLUDE = "io.helidon.common.serviceloader.exclude";
    private static final System.Logger LOGGER = System.getLogger(HelidonServiceLoader.class.getName());
    private final List<T> services;

    private HelidonServiceLoader(List<T> services) {
        this.services = new LinkedList<T>(services);
    }

    public static <T> Builder<T> builder(ServiceLoader<T> serviceLoader) {
        return new Builder<T>(serviceLoader);
    }

    public static <T> HelidonServiceLoader<T> create(Class<T> theProviderInterface) {
        HelidonServiceLoader.class.getModule().addUses(theProviderInterface);
        return HelidonServiceLoader.create(ServiceLoader.load(theProviderInterface));
    }

    public static <T> HelidonServiceLoader<T> create(ServiceLoader<T> serviceLoader) {
        Builder<T> builder = HelidonServiceLoader.builder(serviceLoader);
        return builder.build();
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.services).iterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.services.forEach(action);
    }

    public List<T> asList() {
        return new LinkedList<T>(this.services);
    }

    public Stream<T> stream() {
        return this.asList().stream();
    }

    public static final class Builder<T>
    implements io.helidon.common.Builder<Builder<T>, HelidonServiceLoader<T>> {
        private final ServiceLoader<T> serviceLoader;
        private final List<ServiceWithWeight<T>> customServices = new LinkedList<ServiceWithWeight<T>>();
        private final Set<String> excludedServiceClasses = new HashSet<String>();
        private boolean useSysPropExclude = true;
        private boolean useSystemServiceLoader = true;
        private boolean replaceImplementations = true;
        private double defaultWeight = 100.0;

        private Builder(ServiceLoader<T> serviceLoader) {
            this.serviceLoader = serviceLoader;
        }

        @Override
        public HelidonServiceLoader<T> build() {
            LinkedList<ServiceWithWeight<T>> services = new LinkedList<ServiceWithWeight<T>>(this.customServices);
            if (this.useSystemServiceLoader) {
                HashSet uniqueImplementations = new HashSet();
                if (this.replaceImplementations) {
                    this.customServices.stream().map(ServiceWithWeight::instanceClassName).forEach(uniqueImplementations::add);
                }
                this.serviceLoader.forEach(service -> {
                    if (this.replaceImplementations) {
                        if (!uniqueImplementations.contains(service.getClass().getName())) {
                            services.add(ServiceWithWeight.createFindWeight(service, this.defaultWeight));
                        }
                    } else {
                        services.add(ServiceWithWeight.createFindWeight(service, this.defaultWeight));
                    }
                });
            }
            if (this.useSysPropExclude) {
                this.addSystemExcludes();
            }
            List<ServiceWithWeight<T>> withoutExclusions = services.stream().filter(this::notExcluded).collect(Collectors.toList());
            return new HelidonServiceLoader<T>(this.orderByWeight(withoutExclusions));
        }

        public Builder<T> useSystemExcludes(boolean useSysPropExclude) {
            this.useSysPropExclude = useSysPropExclude;
            return this;
        }

        public Builder<T> useSystemServiceLoader(boolean useServiceLoader) {
            this.useSystemServiceLoader = useServiceLoader;
            return this;
        }

        public Builder<T> replaceImplementations(boolean replace) {
            this.replaceImplementations = replace;
            return this;
        }

        public Builder<T> addService(T service) {
            this.customServices.add(ServiceWithWeight.createFindWeight(service, this.defaultWeight));
            return this;
        }

        public Builder<T> addService(T service, double weight) {
            this.customServices.add(ServiceWithWeight.create(service, weight));
            return this;
        }

        public Builder<T> addExcludedClass(Class<? extends T> excluded) {
            this.excludedServiceClasses.add(excluded.getName());
            return this;
        }

        public Builder<T> addExcludedClassName(String excludeName) {
            this.excludedServiceClasses.add(excludeName);
            return this;
        }

        public Builder<T> defaultWeight(double defaultWeight) {
            this.defaultWeight = defaultWeight;
            return this;
        }

        private boolean notExcluded(ServiceWithWeight<T> service) {
            String className = service.instance.getClass().getName();
            if (this.excludedServiceClasses.contains(className)) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Excluding service implementation " + className);
                }
                return false;
            }
            return true;
        }

        private List<T> orderByWeight(List<ServiceWithWeight<T>> services) {
            Collections.sort(services);
            List result = services.stream().map(ServiceWithWeight::instance).collect(Collectors.toList());
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                List names = result.stream().map(Object::getClass).map(Class::getName).collect(Collectors.toList());
                LOGGER.log(System.Logger.Level.TRACE, "Final order of enabled service implementations for service: " + String.valueOf(this.serviceLoader) + "\n" + String.join((CharSequence)"\n", names));
            }
            return result;
        }

        private void addSystemExcludes() {
            String excludes = System.getProperty(HelidonServiceLoader.SYSTEM_PROPERTY_EXCLUDE);
            if (null == excludes) {
                return;
            }
            for (String exclude : excludes.split(",")) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Adding exclude from system properties: " + exclude);
                }
                this.addExcludedClassName(exclude);
            }
        }

        private static final class ServiceWithWeight<T>
        implements Weighted {
            private final T instance;
            private final double weight;

            private ServiceWithWeight(T instance, double weight) {
                this.instance = instance;
                this.weight = weight;
                if (weight < 0.0) {
                    throw new IllegalArgumentException("Service: " + instance.getClass().getName() + " declares a negative weight, which is not allowed. Weight: " + weight);
                }
            }

            public String toString() {
                return this.instance.toString();
            }

            @Override
            public double weight() {
                return this.weight;
            }

            private static <T> ServiceWithWeight<T> create(T instance, double weight) {
                return new ServiceWithWeight<T>(instance, weight);
            }

            private static <T> ServiceWithWeight<T> createFindWeight(T instance, double defaultWeight) {
                return new ServiceWithWeight<T>(instance, Weights.find(instance, defaultWeight));
            }

            private T instance() {
                return this.instance;
            }

            private String instanceClassName() {
                return this.instance.getClass().getName();
            }
        }
    }
}

