/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.SizeImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface Size {
    public static final Size ZERO = Size.create(0L);

    public static Size create(long size) {
        return new SizeImpl(BigInteger.valueOf(size));
    }

    public static Size create(long amount, Unit unit) {
        Objects.requireNonNull(unit, "Unit must not be null");
        return new SizeImpl(BigInteger.valueOf(amount).multiply(unit.bytesInteger()));
    }

    public static Size create(BigDecimal amount, Unit unit) {
        Objects.requireNonNull(amount, "Amount must not be null");
        Objects.requireNonNull(unit, "Unit must not be null");
        BigDecimal result = amount.multiply(new BigDecimal(unit.bytesInteger()));
        return new SizeImpl(result.toBigIntegerExact());
    }

    public static Size parse(String sizeString) {
        Objects.requireNonNull(sizeString, "Size string is null");
        String parsed = sizeString.trim();
        if (parsed.isEmpty()) {
            throw new IllegalArgumentException("Size string is empty.");
        }
        int lastSpace = parsed.lastIndexOf(32);
        if (lastSpace == -1) {
            return Size.create(new BigDecimal(parsed), Unit.BYTE);
        }
        String size = parsed.substring(0, lastSpace);
        Unit unit = Unit.parse(parsed.substring(lastSpace + 1));
        BigDecimal amount = new BigDecimal(size);
        return Size.create(amount, unit);
    }

    public BigDecimal to(Unit var1);

    public long toBytes();

    public String toString(UnitKind var1);

    public String toString(Unit var1, UnitKind var2);

    public static enum Unit {
        BYTE(1024, 0, "b", "B"),
        KB(1000, 1, "kB", "kb"),
        KIB(1024, 1, "KB", "KiB"),
        MB(1000, 2, "mB", "mb"),
        MIB(1024, 2, "MB", "MiB"),
        GB(1000, 3, "gB", "gb"),
        GIB(1024, 3, "GB", "GiB"),
        TB(1000, 4, "tB", "tb"),
        TIB(1024, 4, "TB", "TiB"),
        PB(1000, 5, "pB", "pb"),
        PIB(1024, 5, "PB", "PiB"),
        EB(1000, 6, "eB", "eb"),
        EIB(1024, 6, "EB", "EiB");

        private static final Map<String, Unit> UNIT_MAP;
        private final long bytes;
        private final int power;
        private final BigInteger bytesInteger;
        private final Set<String> units;
        private final boolean binary;
        private final String firstUnit;
        private final String secondUnit;

        private Unit(int base, int power, String firstUnit, String secondUnit) {
            this.firstUnit = firstUnit;
            this.secondUnit = secondUnit;
            this.units = Set.of(firstUnit, secondUnit);
            this.bytes = (long)Math.pow(base, power);
            this.bytesInteger = BigInteger.valueOf(this.bytes);
            this.power = power;
            this.binary = base == 1024;
        }

        public static Unit parse(String unitString) {
            if (unitString.isEmpty()) {
                return BYTE;
            }
            Unit unit = UNIT_MAP.get(unitString);
            if (unit == null) {
                throw new IllegalArgumentException("Unknown unit: " + unitString);
            }
            return unit;
        }

        public long bytes() {
            return this.bytes;
        }

        public BigInteger bytesInteger() {
            return this.bytesInteger;
        }

        String unitString(UnitKind unitKind) {
            if (this.power == 0) {
                if (unitKind == UnitKind.DECIMAL_LOWER_CASE) {
                    return "b";
                }
                return "B";
            }
            return switch (unitKind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 3 -> this.firstUnit;
                case 1, 2 -> this.secondUnit;
            };
        }

        boolean isBinary() {
            return this.binary;
        }

        static {
            HashMap<String, Unit> units = new HashMap<String, Unit>();
            for (Unit unit : Unit.values()) {
                for (String validUnitString : unit.units) {
                    units.put(validUnitString, unit);
                }
            }
            UNIT_MAP = Map.copyOf(units);
        }
    }

    public static enum UnitKind {
        DECIMAL_UPPER_CASE(false),
        DECIMAL_LOWER_CASE(false),
        BINARY_BI(true),
        BINARY_UPPER_CASE(true);

        private final boolean isBinary;

        private UnitKind(boolean isBinary) {
            this.isBinary = isBinary;
        }

        boolean isBinary() {
            return this.isBinary;
        }
    }
}

