/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.KVP;
import com.esaulpaugh.headlong.util.Integers;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public final class RLPEncoder {
    private RLPEncoder() {
    }

    static int payloadLen(byte[] seqBytes, Iterable<KVP> sorted) {
        long sum = RLPEncoder.stringEncodedLen(seqBytes);
        for (KVP pair : sorted) {
            sum += (long)pair.rlp.length;
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    static byte[] encodeRecordContent(byte[] seqBytes, Iterable<KVP> sorted, int dataLen) {
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.itemLen(dataLen));
        RLPEncoder.insertListPrefix(dataLen, bb);
        RLPEncoder.putString(seqBytes, bb);
        for (KVP pair : sorted) {
            pair.export(bb);
        }
        return bb.array();
    }

    static int itemLen(int dataLen) {
        return (RLPEncoder.isShort(dataLen) ? 1 : 1 + Integers.len(dataLen)) + dataLen;
    }

    static void insertListPrefix(int dataLen, ByteBuffer bb) {
        if (RLPEncoder.isShort(dataLen)) {
            bb.put((byte)(-64 + dataLen));
        } else {
            int len = Integers.len(dataLen);
            bb.put((byte)(-9 + len));
            Integers.putLong((long)dataLen, len, bb);
        }
    }

    private static int requireNoOverflow(long length) {
        if (length >= 0L && length <= Integer.MAX_VALUE) {
            return (int)length;
        }
        throw new ArithmeticException("integer overflow");
    }

    private static boolean isShort(int dataLen) {
        return dataLen < 56;
    }

    private static int sumEncodedLen(Iterable<?> rawItems) {
        long sum = 0L;
        for (Object raw : rawItems) {
            sum += (long)RLPEncoder.encodedLen(raw);
        }
        return RLPEncoder.requireNoOverflow(sum);
    }

    private static int encodedLen(Object raw) {
        if (raw instanceof byte[]) {
            return RLPEncoder.stringEncodedLen((byte[])raw);
        }
        if (raw instanceof Iterable) {
            return RLPEncoder.listEncodedLen((Iterable)raw);
        }
        if (raw instanceof Object[]) {
            return RLPEncoder.listEncodedLen(Arrays.asList((Object[])raw));
        }
        throw new IllegalArgumentException("unsupported object type. expected instanceof byte[], Iterable, or Object[]");
    }

    private static int stringEncodedLen(byte[] byteString) {
        return RLPEncoder.itemLen(byteString.length == 1 && DataType.isSingleByte(byteString[0]) ? 0 : byteString.length);
    }

    private static int listEncodedLen(Iterable<?> items) {
        return RLPEncoder.itemLen(RLPEncoder.sumEncodedLen(items));
    }

    private static void encodeItem(Object raw, ByteBuffer bb) {
        if (raw instanceof byte[]) {
            RLPEncoder.putString((byte[])raw, bb);
        } else if (raw instanceof Iterable) {
            Iterable elements = (Iterable)raw;
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else if (raw instanceof Object[]) {
            List<Object> elements = Arrays.asList((Object[])raw);
            RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, bb);
        } else {
            throw new IllegalArgumentException("unsupported object type. expected instanceof byte[], Iterable, or Object[]");
        }
    }

    private static void encodeList(int dataLen, Iterable<?> elements, ByteBuffer bb) {
        RLPEncoder.insertListPrefix(dataLen, bb);
        RLPEncoder.putSequence(elements, bb);
    }

    public static byte[] string(byte[] byteString) {
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.stringEncodedLen(byteString));
        RLPEncoder.putString(byteString, bb);
        return bb.array();
    }

    public static void putString(byte[] byteString, ByteBuffer dest) {
        if (byteString.length == 1) {
            if (byteString[0] < 0) {
                dest.put((byte)-127);
            }
        } else if (RLPEncoder.isShort(byteString.length)) {
            dest.put((byte)(-128 + byteString.length));
        } else {
            int len = Integers.len(byteString.length);
            dest.put((byte)(-73 + len));
            Integers.putLong((long)byteString.length, len, dest);
        }
        dest.put(byteString);
    }

    public static byte[] sequence(Object ... objects) {
        return RLPEncoder.sequence(Arrays.asList(objects));
    }

    public static byte[] sequence(Iterable<?> objects) {
        byte[] dest = new byte[RLPEncoder.sumEncodedLen(objects)];
        RLPEncoder.putSequence(objects, dest, 0);
        return dest;
    }

    public static int putSequence(Iterable<?> objects, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.putSequence(objects, bb);
        return bb.position();
    }

    public static void putSequence(Iterable<?> objects, ByteBuffer dest) {
        for (Object raw : objects) {
            RLPEncoder.encodeItem(raw, dest);
        }
    }

    public static byte[] list(Object ... elements) {
        return RLPEncoder.list(Arrays.asList(elements));
    }

    public static byte[] list(Iterable<?> elements) {
        int dataLen = RLPEncoder.sumEncodedLen(elements);
        ByteBuffer bb = ByteBuffer.allocate(RLPEncoder.itemLen(dataLen));
        RLPEncoder.encodeList(dataLen, elements, bb);
        return bb.array();
    }

    public static int putList(Iterable<?> elements, byte[] dest, int destIndex) {
        ByteBuffer bb = ByteBuffer.wrap(dest, destIndex, dest.length - destIndex);
        RLPEncoder.putList(elements, bb);
        return bb.position();
    }

    public static void putList(Iterable<?> elements, ByteBuffer dest) {
        RLPEncoder.encodeList(RLPEncoder.sumEncodedLen(elements), elements, dest);
    }
}

