/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.impl.converters;

import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class EnumConverter<T extends Enum<T>>
implements ConfigConverter<T> {
    private final Class<T> valueType;

    public EnumConverter(@NonNull Class<T> valueType) {
        this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
    }

    @Nullable
    public T convert(@NonNull String value) throws IllegalArgumentException, NullPointerException {
        try {
            return Enum.valueOf(this.valueType, Objects.requireNonNull(value, "value must not be null"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can not convert value '%s' of Enum '%s' by default. Please add a custom config converter.".formatted(value, this.valueType), e);
        }
    }
}

