/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.base.utility.Pair;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotWriter;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.utility.Labeled;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.config.api.Configuration;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.BackedReadableKVState;
import com.swirlds.state.merkle.disk.BackedWritableKVState;
import com.swirlds.state.merkle.memory.InMemoryReadableKVState;
import com.swirlds.state.merkle.memory.InMemoryWritableKVState;
import com.swirlds.state.merkle.queue.BackedReadableQueueState;
import com.swirlds.state.merkle.queue.BackedWritableQueueState;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.BackedReadableSingletonState;
import com.swirlds.state.merkle.singleton.BackedWritableSingletonState;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.VirtualMapMigration;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableConsumer;
import org.hiero.base.constructable.ConstructableIgnored;

@Deprecated
@ConstructableIgnored
public abstract class MerkleStateRoot<T extends MerkleStateRoot<T>>
extends PartialNaryMerkleInternal
implements MerkleInternal,
State {
    private static final Logger logger = LogManager.getLogger(MerkleStateRoot.class);
    private static final long CLASS_ID = -8201042766723040485L;
    public static final int MINIMUM_SUPPORTED_VERSION = 31;
    public static final int CURRENT_VERSION = 32;
    private static final Map<String, Integer> INDEX_LOOKUP = new ConcurrentHashMap<String, Integer>();
    private LongSupplier roundSupplier;
    private MerkleCryptography merkleCryptography;
    private Time time;
    private Configuration configuration;
    private Metrics metrics;
    private MerkleRootSnapshotMetrics snapshotMetrics = new MerkleRootSnapshotMetrics();
    private final Map<String, Map<String, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private final RuntimeObjectRecord registryRecord = RuntimeObjectRegistry.createRecord(((Object)((Object)this)).getClass());
    private boolean startupMode = true;
    private static final int DATA_PER_COPY = 10213;

    public Map<String, Map<String, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public MerkleStateRoot() {
    }

    public void init(Time time, Configuration configuration, Metrics metrics, MerkleCryptography merkleCryptography, LongSupplier roundSupplier) {
        this.time = time;
        this.configuration = configuration;
        this.metrics = metrics;
        this.merkleCryptography = merkleCryptography;
        this.roundSupplier = roundSupplier;
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
    }

    protected MerkleStateRoot(@NonNull MerkleStateRoot<T> from) {
        super(from);
        this.listeners.addAll(from.listeners);
        this.roundSupplier = from.roundSupplier;
        this.startupMode = from.startupMode;
        for (Map.Entry<String, Map<String, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
        int n = from.getNumberOfChildren();
        for (int childIndex = 0; childIndex < n; ++childIndex) {
            MerkleNode childToCopy = from.getChild(childIndex);
            if (childToCopy == null) continue;
            this.setChild(childIndex, childToCopy.copy());
        }
    }

    public void disableStartupMode() {
        this.startupMode = false;
    }

    public boolean isStartUpMode() {
        return this.startupMode;
    }

    public boolean isHashed() {
        return this.getHash() != null;
    }

    public long getClassId() {
        return -8201042766723040485L;
    }

    public int getVersion() {
        return 32;
    }

    public int getMinimumSupportedVersion() {
        return 31;
    }

    public void close() {
        logger.info("Closing MerkleStateRoot");
        for (Map<String, StateMetadata<?, ?>> svc : this.services.values()) {
            for (StateMetadata<?, ?> md : svc.values()) {
                MerkleNode node;
                int index = this.findNodeIndex(md.serviceName(), MerkleStateRoot.extractStateKey(md));
                if (index < 0 || !((node = this.getChild(index)) instanceof VirtualMap)) continue;
                VirtualMap virtualMap = (VirtualMap)node;
                try {
                    virtualMap.getDataSource().close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close data source for virtual map {}", (Object)md.serviceName(), (Object)e);
                }
            }
        }
    }

    public void destroyNode() {
        this.registryRecord.release();
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(this, stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public T copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        this.setImmutable(true);
        return this.copyingConstructor();
    }

    protected abstract T copyingConstructor();

    public <T extends MerkleNode> void putServiceStateIfAbsent(@NonNull StateMetadata<?, ?> md, @NonNull Supplier<T> nodeSupplier, @NonNull Consumer<T> nodeInitializer) {
        MerkleNode node;
        this.throwIfImmutable();
        Objects.requireNonNull(md);
        Objects.requireNonNull(nodeSupplier);
        Objects.requireNonNull(nodeInitializer);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateKey(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(this, stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
        int nodeIndex = this.findNodeIndex(serviceName, def.stateKey());
        if (nodeIndex == -1) {
            String label;
            node = Objects.requireNonNull((MerkleNode)nodeSupplier.get());
            if (node instanceof Labeled) {
                Labeled labeled = (Labeled)node;
                v0 = labeled.getLabel();
            } else {
                v0 = label = null;
            }
            if (label == null) {
                throw new IllegalArgumentException("`node` must be a Labeled and have a label");
            }
            if (def.onDisk() && !(node instanceof VirtualMap)) {
                throw new IllegalArgumentException("Mismatch: state definition claims on-disk, but the merkle node is not a VirtualMap");
            }
            if (label.isEmpty()) {
                throw new IllegalArgumentException("A label must be specified on the node");
            }
            if (!label.equals(StateMetadata.computeLabel((String)serviceName, (String)def.stateKey()))) {
                throw new IllegalArgumentException("A label must be computed based on the same service name and state key in the metadata!");
            }
            this.setChild(this.getNumberOfChildren(), node);
        } else {
            node = this.getChild(nodeIndex);
        }
        nodeInitializer.accept(node);
    }

    public void unregisterService(@NonNull String serviceName) {
        this.readableStatesMap.remove(serviceName);
        this.writableStatesMap.remove(serviceName);
        this.services.remove(serviceName);
    }

    public void removeServiceState(@NonNull String serviceName, @NonNull String stateKey) {
        int index;
        MerkleWritableStates writableStates;
        this.throwIfImmutable();
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(stateKey);
        Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(serviceName);
        if (stateMetadata != null) {
            stateMetadata.remove(stateKey);
        }
        if ((writableStates = this.writableStatesMap.get(serviceName)) != null) {
            writableStates.remove(stateKey);
        }
        if ((index = this.findNodeIndex(serviceName, stateKey)) != -1) {
            this.setChild(index, null);
        }
    }

    public int findNodeIndex(@NonNull String serviceName, @NonNull String stateKey) {
        String label = StateMetadata.computeLabel((String)serviceName, (String)stateKey);
        Integer index = INDEX_LOOKUP.get(label);
        if (index != null && this.checkNodeIndex(index, label)) {
            return index;
        }
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            if (!this.checkNodeIndex(i, label)) continue;
            INDEX_LOOKUP.put(label, i);
            return i;
        }
        INDEX_LOOKUP.remove(label);
        return -1;
    }

    private boolean checkNodeIndex(int index, @NonNull String label) {
        Labeled labeled;
        MerkleNode node = this.getChild(index);
        return node instanceof Labeled && Objects.equals(label, (labeled = (Labeled)node).getLabel());
    }

    @NonNull
    private static String extractStateKey(@NonNull StateMetadata<?, ?> md) {
        return md.stateDefinition().stateKey();
    }

    public void commitSingletons() {
        this.services.forEach((serviceKey, serviceStates) -> serviceStates.entrySet().stream().filter(stateMetadata -> ((StateMetadata)stateMetadata.getValue()).stateDefinition().singleton()).forEach(service -> {
            WritableStates writableStates = this.getWritableStates((String)serviceKey);
            WritableSingletonStateBase writableSingleton = (WritableSingletonStateBase)writableStates.getSingleton((String)service.getKey());
            writableSingleton.commit();
        }));
    }

    public void computeHash() {
        Objects.requireNonNull(this.merkleCryptography, "MerkleStateRoot has to be initialized before hashing. merkleCryptography is not set.");
        this.throwIfMutable("Hashing should only be done on immutable states");
        this.throwIfDestroyed("Hashing should not be done on destroyed states");
        if (this.getHash() != null) {
            return;
        }
        try {
            this.merkleCryptography.digestTreeAsync((MerkleNode)this).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred during hashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while hashing state. Expect buggy behavior.");
            Thread.currentThread().interrupt();
        }
    }

    public void createSnapshot(@NonNull Path targetPath) {
        Objects.requireNonNull(this.time);
        Objects.requireNonNull(this.snapshotMetrics);
        this.throwIfMutable();
        this.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        MerkleTreeSnapshotWriter.createSnapshot((MerkleNode)this, (Path)targetPath, (long)this.roundSupplier.getAsLong());
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    public T loadSnapshot(@NonNull Path targetPath) throws IOException {
        return (T)((Object)((MerkleStateRoot)MerkleTreeSnapshotReader.readStateFileData((Configuration)this.configuration, (Path)targetPath).stateRoot()));
    }

    public MerkleNode migrate(@NonNull Configuration configuration, int version) {
        if (version < 32) {
            boolean validateMigrationEnabled = ((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class)).validateMigrationEnabled();
            MerkleDbConfig merkleDbConfig = (MerkleDbConfig)configuration.getConfigData(MerkleDbConfig.class);
            MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(configuration, merkleDbConfig.initialCapacity(), merkleDbConfig.hashesRamToDiskThreshold());
            VirtualMap virtualMap = new VirtualMap("state", (VirtualDataSourceBuilder)dsBuilder, configuration);
            AtomicLong totalMigratedObjects = new AtomicLong(0L);
            AtomicLong totalMigrationTimeMs = new AtomicLong(0L);
            AtomicLong totalValidationTimeMs = new AtomicLong(0L);
            logger.info(LogMarker.STARTUP.getMarker(), "Migrating all of the states (Singleton, KV and Queue) to the one Virtual Map...");
            this.migrateSingletonStates(virtualMap, totalMigratedObjects, totalMigrationTimeMs, validateMigrationEnabled, totalValidationTimeMs);
            AtomicReference<VirtualMap> virtualMapRef = new AtomicReference<VirtualMap>(virtualMap);
            this.migrateQueueStates(virtualMapRef, totalMigratedObjects, totalMigrationTimeMs, validateMigrationEnabled, totalValidationTimeMs);
            this.migrateKVStates(virtualMapRef, totalMigratedObjects, totalMigrationTimeMs, validateMigrationEnabled, totalValidationTimeMs);
            logger.info(LogMarker.STARTUP.getMarker(), "Total migration time {} ms", (Object)totalMigrationTimeMs.get());
            if (validateMigrationEnabled) {
                assert (virtualMapRef.get().size() == totalMigratedObjects.get());
                logger.info(LogMarker.STARTUP.getMarker(), "Total validation time {} ms", (Object)totalValidationTimeMs.get());
            }
            return (MerkleNode)virtualMapRef.get();
        }
        return this;
    }

    private void migrateSingletonStates(VirtualMap virtualMap, AtomicLong totalMigratedObjects, AtomicLong totalMigrationTimeMs, boolean validateMigrationEnabled, AtomicLong totalValidationTimeMs) {
        logger.info(LogMarker.STARTUP.getMarker(), "Migrating Singleton states to the one Virtual Map...");
        AtomicLong singletonMigrationTimeMs = new AtomicLong(0L);
        IntStream.range(0, this.getNumberOfChildren()).mapToObj(arg_0 -> ((MerkleStateRoot)this).getChild(arg_0)).filter(child -> child instanceof SingletonNode).map(child -> (SingletonNode)((Object)((Object)child))).forEach(singletonNode -> {
            StringLeaf originalLabeled = (StringLeaf)singletonNode.getLeft();
            String singletonStateLabel = originalLabeled.getLabel();
            Pair<String, String> labelPair = StateUtils.decomposeLabel(singletonStateLabel);
            String serviceName = (String)labelPair.key();
            String stateKey = (String)labelPair.value();
            ValueLeaf originalStore = (ValueLeaf)singletonNode.getRight();
            logger.info(LogMarker.STARTUP.getMarker(), "\nMigrating {}...", (Object)singletonStateLabel);
            long migrationStartTime = System.currentTimeMillis();
            Object value = Objects.requireNonNull(originalStore.getValue(), "Null value is not expected here");
            Bytes key = StateUtils.getStateKeyForSingleton(serviceName, stateKey);
            StateValue stateValue = StateUtils.getStateValue(serviceName, stateKey, value);
            virtualMap.put(key, (Object)stateValue, StateValue.PROTOBUF);
            long migrationTimeMs = System.currentTimeMillis() - migrationStartTime;
            logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for {} took {} ms", (Object)singletonStateLabel, (Object)migrationTimeMs);
            logger.info(LogMarker.STARTUP.getMarker(), "New Virtual Map size: {}", (Object)virtualMap.size());
            singletonMigrationTimeMs.addAndGet(migrationTimeMs);
            totalMigrationTimeMs.addAndGet(migrationTimeMs);
            if (validateMigrationEnabled) {
                totalMigratedObjects.addAndGet(1L);
                long validationStartTime = System.currentTimeMillis();
                logger.info(LogMarker.STARTUP.getMarker(), "Validating the new Virtual Map contains all data from the Singleton State {}", (Object)singletonStateLabel);
                MerkleStateRoot.validateSingletonStateMigrated(virtualMap, serviceName, stateKey);
                long validationTimeMs = System.currentTimeMillis() - validationStartTime;
                logger.info(LogMarker.STARTUP.getMarker(), "Validation complete for the Singleton State {} took {} ms", (Object)singletonStateLabel, (Object)validationTimeMs);
                totalValidationTimeMs.addAndGet(validationTimeMs);
            }
        });
        logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for Singleton states, took {} ms", (Object)singletonMigrationTimeMs);
    }

    private static void validateSingletonStateMigrated(VirtualMap virtualMap, String serviceName, String stateKey) {
        assert (virtualMap.containsKey(StateUtils.getStateKeyForSingleton(serviceName, stateKey)));
    }

    private void migrateQueueStates(AtomicReference<VirtualMap> virtualMapRef, AtomicLong totalMigratedObjects, AtomicLong totalMigrationTimeMs, boolean validateMigrationEnabled, AtomicLong totalValidationTimeMs) {
        logger.info(LogMarker.STARTUP.getMarker(), "Migrating Queue states to the one Virtual Map...");
        AtomicLong queueMigrationStartTime = new AtomicLong(0L);
        IntStream.range(0, this.getNumberOfChildren()).mapToObj(arg_0 -> ((MerkleStateRoot)this).getChild(arg_0)).filter(child -> child instanceof QueueNode).map(child -> (QueueNode)((Object)((Object)child))).forEach(queueNode -> {
            String queueNodeLabel = queueNode.getLabel();
            Pair<String, String> labelPair = StateUtils.decomposeLabel(queueNodeLabel);
            String serviceName = (String)labelPair.key();
            String stateKey = (String)labelPair.value();
            FCQueue originalStore = (FCQueue)queueNode.getRight();
            logger.info(LogMarker.STARTUP.getMarker(), "\nMigrating {} (size: {})...", (Object)queueNodeLabel, (Object)originalStore.size());
            long migrationStartTime = System.currentTimeMillis();
            long head = 1L;
            long tail = 1L;
            for (ValueLeaf leaf : originalStore) {
                Object value = Objects.requireNonNull(leaf.getValue(), "Null value is not expected here");
                VirtualMap currentMap = (VirtualMap)virtualMapRef.get();
                if (currentMap.size() % 10213L == 0L) {
                    VirtualMap older = currentMap;
                    currentMap = currentMap.copy();
                    older.release();
                    virtualMapRef.set(currentMap);
                }
                Bytes key = StateUtils.getStateKeyForQueue(serviceName, stateKey, tail++);
                StateValue stateValue = StateUtils.getStateValue(serviceName, stateKey, value);
                ((VirtualMap)virtualMapRef.get()).put(key, (Object)stateValue, StateValue.PROTOBUF);
            }
            QueueState queueState = new QueueState(1L, tail);
            ((VirtualMap)virtualMapRef.get()).put(StateUtils.getStateKeyForSingleton(serviceName, stateKey), (Object)StateUtils.getQueueStateValue(queueState), StateValue.PROTOBUF);
            long migrationTimeMs = System.currentTimeMillis() - migrationStartTime;
            logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for {} took {} ms", (Object)queueNodeLabel, (Object)migrationTimeMs);
            logger.info(LogMarker.STARTUP.getMarker(), "New Virtual Map size: {}", (Object)((VirtualMap)virtualMapRef.get()).size());
            queueMigrationStartTime.addAndGet(migrationTimeMs);
            totalMigrationTimeMs.addAndGet(migrationTimeMs);
            if (validateMigrationEnabled) {
                totalMigratedObjects.addAndGet(originalStore.size());
                totalMigratedObjects.addAndGet(1L);
                long validationStartTime = System.currentTimeMillis();
                logger.info(LogMarker.STARTUP.getMarker(), "Validating the new Virtual Map contains all data from the Queue State {}", (Object)queueNodeLabel);
                MerkleStateRoot.validateQueueStateMigrated((VirtualMap)virtualMapRef.get(), serviceName, stateKey, 1L, tail);
                long validationTimeMs = System.currentTimeMillis() - validationStartTime;
                logger.info(LogMarker.STARTUP.getMarker(), "Validation complete for the Queue State {} took {} ms", (Object)queueNodeLabel, (Object)validationTimeMs);
                totalValidationTimeMs.addAndGet(validationTimeMs);
            }
        });
        logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for Queue states, took {} ms", (Object)queueMigrationStartTime.get());
    }

    private static void validateQueueStateMigrated(VirtualMap virtualMap, String serviceName, String stateKey, long head, long tail) {
        assert (virtualMap.containsKey(StateUtils.getStateKeyForSingleton(serviceName, stateKey)));
        for (long i = head; i < tail; ++i) {
            assert (virtualMap.containsKey(StateUtils.getStateKeyForQueue(serviceName, stateKey, i)));
        }
    }

    private void migrateKVStates(AtomicReference<VirtualMap> virtualMapRef, AtomicLong totalMigratedObjects, AtomicLong totalMigrationTimeMs, boolean validateMigrationEnabled, AtomicLong totalValidationTimeMs) {
        logger.info(LogMarker.STARTUP.getMarker(), "Migrating KV states to the one Virtual Map...");
        AtomicLong kvMigrationStartTime = new AtomicLong(0L);
        IntStream.range(0, this.getNumberOfChildren()).mapToObj(arg_0 -> ((MerkleStateRoot)this).getChild(arg_0)).filter(child -> child instanceof VirtualMap).map(child -> (VirtualMap)child).forEach(virtualMapToMigrate -> {
            String virtualMapLabel = virtualMapToMigrate.getLabel();
            Pair<String, String> labelPair = StateUtils.decomposeLabel(virtualMapToMigrate.getLabel());
            String serviceName = (String)labelPair.key();
            String stateKey = (String)labelPair.value();
            InterruptableConsumer handler = pair -> {
                VirtualMap currentMap = (VirtualMap)virtualMapRef.get();
                if (currentMap.size() % 10213L == 0L) {
                    VirtualMap older = currentMap;
                    currentMap = currentMap.copy();
                    older.release();
                    virtualMapRef.set(currentMap);
                }
                Bytes keyBytes = StateUtils.getStateKeyValueBytes(serviceName, stateKey, (Bytes)pair.key());
                Bytes valueBytes = StateUtils.getStateKeyValueBytes(serviceName, stateKey, (Bytes)pair.value());
                ((VirtualMap)virtualMapRef.get()).putBytes(keyBytes, valueBytes);
            };
            try {
                logger.info(LogMarker.STARTUP.getMarker(), "\nMigrating {} (size: {})...", (Object)virtualMapLabel, (Object)virtualMapToMigrate.size());
                long migrationStartTime = System.currentTimeMillis();
                VirtualMapMigration.extractVirtualMapData((ThreadManager)AdHocThreadManager.getStaticThreadManager(), (VirtualMap)virtualMapToMigrate, (InterruptableConsumer)handler, (int)(Runtime.getRuntime().availableProcessors() - 1));
                long migrationTimeMs = System.currentTimeMillis() - migrationStartTime;
                logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for {} took {} ms", (Object)virtualMapLabel, (Object)migrationTimeMs);
                logger.info(LogMarker.STARTUP.getMarker(), "New Virtual Map size: {}", (Object)((VirtualMap)virtualMapRef.get()).size());
                kvMigrationStartTime.addAndGet(migrationTimeMs);
                totalMigrationTimeMs.addAndGet(migrationTimeMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Virtual Map migration process was interrupted", e);
            }
            if (validateMigrationEnabled) {
                totalMigratedObjects.addAndGet(virtualMapToMigrate.size());
                long validationStartTime = System.currentTimeMillis();
                logger.info(LogMarker.STARTUP.getMarker(), "Validating the new Virtual Map contains all data from the KV State {}", (Object)virtualMapToMigrate.getLabel());
                MerkleStateRoot.validateKVStateMigrated((VirtualMap)virtualMapRef.get(), virtualMapToMigrate, serviceName, stateKey);
                long validationTimeMs = System.currentTimeMillis() - validationStartTime;
                logger.info(LogMarker.STARTUP.getMarker(), "Validation complete for the KV State {} took {} ms", (Object)virtualMapToMigrate.getLabel(), (Object)validationTimeMs);
                totalValidationTimeMs.addAndGet(validationTimeMs);
            }
        });
        logger.info(LogMarker.STARTUP.getMarker(), "Migration complete for KV states, took {} ms", (Object)kvMigrationStartTime.get());
    }

    private static void validateKVStateMigrated(VirtualMap virtualMap, VirtualMap virtualMapToMigrate, String serviceName, String stateKey) {
        MerkleIterator merkleNodeMerkleIterator = virtualMapToMigrate.treeIterator();
        while (merkleNodeMerkleIterator.hasNext()) {
            MerkleNode next = merkleNodeMerkleIterator.next();
            if (!(next instanceof VirtualLeafNode)) continue;
            VirtualLeafNode virtualLeafNode = (VirtualLeafNode)next;
            Bytes keyBytes = StateUtils.getStateKeyValueBytes(serviceName, stateKey, virtualLeafNode.getKey());
            assert (virtualMap.containsKey(keyBytes));
        }
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(@NonNull MerkleStateRoot this$0, Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            return new BackedReadableKVState(md.serviceName(), MerkleStateRoot.extractStateKey(md), Objects.requireNonNull(md.stateDefinition().keyCodec()), md.stateDefinition().valueCodec(), v);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull MerkleMap m) {
            return new InMemoryReadableKVState(md.serviceName(), MerkleStateRoot.extractStateKey(md), m);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            return new BackedReadableSingletonState(md.serviceName(), MerkleStateRoot.extractStateKey(md), s);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            return new BackedReadableQueueState(md.serviceName(), MerkleStateRoot.extractStateKey(md), q);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        public void copyAndReleaseVirtualMap(@NonNull String stateKey) {
            StateMetadata md = (StateMetadata)this.stateMetadata.get(stateKey);
            VirtualMap virtualMap = (VirtualMap)this.findNode(md).cast();
            VirtualMap mutableCopy = virtualMap.copy();
            if (MerkleStateRoot.this.metrics != null) {
                mutableCopy.registerMetrics(MerkleStateRoot.this.metrics);
            }
            MerkleStateRoot.this.setChild(MerkleStateRoot.this.findNodeIndex(this.serviceName, stateKey), (MerkleNode)mutableCopy);
            this.kvInstances.put(stateKey, this.createReadableKVState(md, mutableCopy));
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
            return (WritableKVState)super.get(stateKey);
        }

        @NonNull
        public <S> WritableSingletonState<S> getSingleton(@NonNull String stateKey) {
            return (WritableSingletonState)super.getSingleton(stateKey);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
            return (WritableQueueState)super.getQueue(stateKey);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            BackedWritableKVState state = new BackedWritableKVState(this.serviceName, MerkleStateRoot.extractStateKey(md), Objects.requireNonNull(md.stateDefinition().keyCodec()), md.stateDefinition().valueCodec(), v);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull MerkleMap m) {
            InMemoryWritableKVState state = new InMemoryWritableKVState(md.serviceName(), MerkleStateRoot.extractStateKey(md), md.inMemoryValueClassId(), md.stateDefinition().keyCodec(), md.stateDefinition().valueCodec(), m);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            BackedWritableSingletonState state = new BackedWritableSingletonState(md.serviceName(), MerkleStateRoot.extractStateKey(md), s);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            BackedWritableQueueState state = new BackedWritableQueueState(md.serviceName(), MerkleStateRoot.extractStateKey(md), q);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            for (ReadableKVState kv : this.kvInstances.values()) {
                ((WritableKVStateBase)kv).commit();
            }
            if (MerkleStateRoot.this.startupMode) {
                for (ReadableSingletonState s : this.singletonInstances.values()) {
                    ((WritableSingletonStateBase)s).commit();
                }
            }
            for (ReadableQueueState q : this.queueInstances.values()) {
                ((WritableQueueStateBase)q).commit();
            }
            MerkleStateRoot.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(String stateKey) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateKey);
            }
            this.kvInstances.remove(stateKey);
            this.singletonInstances.remove(stateKey);
            this.queueInstances.remove(stateKey);
        }

        private <V> void registerSingletonListener(@NonNull String serviceName, @NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = listener.stateIdFor(serviceName, singletonState.getStateKey());
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull String serviceName, @NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, queueState.getStateKey());
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(@NonNull String serviceName, WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, state.getStateKey());
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private abstract class MerkleStates
    implements ReadableStates {
        protected final Map<String, StateMetadata<?, ?>> stateMetadata;
        protected final Map<String, ReadableKVState<?, ?>> kvInstances;
        protected final Map<String, ReadableSingletonState<?>> singletonInstances;
        protected final Map<String, ReadableQueueState<?>> queueInstances;
        private final Set<String> stateKeys;

        MerkleStates(Map<String, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateKeys = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(@NonNull String stateKey) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown k/v state key '" + stateKey + ";");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof VirtualMap) {
                VirtualMap v = (VirtualMap)node;
                ReadableKVState ret = this.createReadableKVState(md, v);
                this.kvInstances.put(stateKey, ret);
                return ret;
            }
            if (node instanceof MerkleMap) {
                MerkleMap m = (MerkleMap)node;
                ReadableKVState ret = this.createReadableKVState(md, m);
                this.kvInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for k/v state " + stateKey);
        }

        @NonNull
        public <S> ReadableSingletonState<S> getSingleton(@NonNull String stateKey) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state key '" + stateKey + "'");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof SingletonNode) {
                SingletonNode s = (SingletonNode)node;
                ReadableSingletonState ret = this.createReadableSingletonState(md, s);
                this.singletonInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for singleton state " + stateKey);
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(@NonNull String stateKey) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state key '" + stateKey + "'");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof QueueNode) {
                QueueNode q = (QueueNode)node;
                ReadableQueueState ret = this.createReadableQueueState(md, q);
                this.queueInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for queue state " + stateKey);
        }

        public boolean contains(@NonNull String stateKey) {
            return this.stateMetadata.containsKey(stateKey);
        }

        @NonNull
        public Set<String> stateKeys() {
            return this.stateKeys;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1, @NonNull VirtualMap var2);

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1, @NonNull MerkleMap var2);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1, @NonNull SingletonNode<?> var2);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1, @NonNull QueueNode<?> var2);

        @NonNull
        MerkleNode findNode(@NonNull StateMetadata<?, ?> md) {
            int index = MerkleStateRoot.this.findNodeIndex(md.serviceName(), MerkleStateRoot.extractStateKey(md));
            if (index == -1) {
                throw new IllegalStateException("State '" + MerkleStateRoot.extractStateKey(md) + "' for service '" + md.serviceName() + "' is missing from the merkle tree!");
            }
            return MerkleStateRoot.this.getChild(index);
        }
    }
}

