/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.fchashmap.internal;

public class Mutation<V> {
    private final long version;
    private V value;
    private Mutation<V> previous;
    private Mutation<V> next;

    public Mutation(long version, V value, Mutation<V> previous) {
        this.version = version;
        this.value = value;
        this.previous = previous;
        if (previous != null) {
            previous.next = this;
        }
    }

    public String toString() {
        return "(version = " + this.version + ", value = " + String.valueOf(this.value == null ? "DELETED" : this.value) + ")";
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public long getVersion() {
        return this.version;
    }

    public Mutation<V> getPrevious() {
        return this.previous;
    }

    public void setPrevious(Mutation<V> previous) {
        this.previous = previous;
    }

    public Mutation<V> getNext() {
        return this.next;
    }

    public void setNext(Mutation<V> next) {
        this.next = next;
    }
}

